//
// Auth.h - Authentication library
// (c) 20205 AnhvuAuth All rights reserved
// Version 1.0
//
// This software is provided under license and may not be
// copied, modified or distributed without permission.
//

#import <Foundation/Foundation.h>

/**
 * Lớp xác thực chính cung cấp giao diện đơn giản cho việc xác thực key
 * Được thiết kế để chống lại các công cụ như class-dump
 */
@interface Auth : NSObject

/**
 * Phương thức runtime động để gọi các API bị ẩn
 * @param selector Tên phương thức (được mã hóa)
 * @param arguments Mảng các tham số
 * @return Kết quả từ lệnh gọi
 */
+ (id)invokeProtectedMethod:(NSString *)selector withArguments:(NSArray *)arguments;

/**
 * Các phương thức lấy thông tin không cần mã hóa để đảm bảo độ ổn định
 */
+ (NSString *)getSavedKey;
+ (NSString *)getRemainingTime;
+ (NSString *)getDeviceInfo;
+ (NSString *)getKeyStatus;
+ (void)detailKey;

@end

// Keep obfuscation only for critical operations like setup, logout and notifications
#define AUTH_SETUP_DONE(appId, completion) \
    [Auth invokeProtectedMethod:@"X9H7dTpQlM5zKbGvYwE3Ag==" withArguments:@[appId ?: @"", completion ?: ^{}]]

#define AUTH_LOGOUT() \
    [Auth invokeProtectedMethod:@"ZmR4eWxoYjEya3o=" withArguments:@[]]

#define AUTH_SHOW_SUCCESS(message) \
    [Auth invokeProtectedMethod:@"Y2t4ZHlwdG0zcnZ3eGU=" withArguments:@[message ?: @""]]

#define AUTH_SHOW_CENTER_NOTIFICATION(title, message, type) \
    [Auth invokeProtectedMethod:@"dnF5cDNrbXJueHQybXduYnB4NXJ3" withArguments:@[title ?: @"", message ?: @"", type ?: @"info"]]

#define AUTH_SHOW_TOP_NOTIFICATION(title, message, type) \
    [Auth invokeProtectedMethod:@"cGJ2NDUzcnQ2bW54dHZwdzNreDVydw==" withArguments:@[title ?: @"", message ?: @"", type ?: @"info"]]

#define AUTH_SHOW_KEY_DETAIL() \
    [Auth detailKey]
